'use strict';

/* --------------------------------------------------------------
 save_bar.js 2017-11-06
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2017 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

gx.controllers.module('save_bar', [], function (data) {

        'use strict';

        // ------------------------------------------------------------------------
        // VARIABLES DEFINITION
        // ------------------------------------------------------------------------
        /**
         * Module Selector
         *
         * @type {jQuery}
         */

        var _this = this;

        var $this = $(this);

        /**
         * Bottom save bar
         *
         * @type {jQuery}
         */
        var $bottomSaveBar = $('.bottom-save-bar');

        /**
         * Save button
         *
         * @type {jQuery}
         */
        var $saveButton = $bottomSaveBar.find('button[name="save"]');

        /**
         * Update button
         *
         * @type {jQuery}
         */
        var $updateButton = $bottomSaveBar.find('button[name="update"]');

        /**
         * Default Options
         *
         * @type {object}
         */
        var defaults = {};

        /**
         * Final Options
         *
         * @type {object}
         */
        var options = $.extend(true, {}, defaults, data);

        /**
         * Module Object
         *
         * @type {object}
         */
        var module = {};

        // ------------------------------------------------------------------------
        // EVENT HANDLERS
        // ------------------------------------------------------------------------

        // Handle save button click
        $saveButton.on('click', function (event) {
                event.preventDefault();
                var formName = $(_this).attr('form');
                var $form = $('form#' + formName);

                $form.submit();
        });

        // Handle update button click
        $updateButton.on('click', function (event) {
                event.preventDefault();
                var formName = $(_this).attr('form');
                var $form = $('form#' + formName);
                var formURL = $form.attr('action');

                // Add another parameter, so that we stay on the same page after
                // the form was submitted
                $form.attr('action', formURL + '&update=1');

                $form.submit();
        });

        // ------------------------------------------------------------------------
        // INITIALIZATION
        // ------------------------------------------------------------------------

        module.init = function (done) {
                done();
        };

        return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImNvbnRlbnRfbWFuYWdlci9zYXZlX2Jhci5qcyJdLCJuYW1lcyI6WyJneCIsImNvbnRyb2xsZXJzIiwibW9kdWxlIiwiZGF0YSIsIiR0aGlzIiwiJCIsIiRib3R0b21TYXZlQmFyIiwiJHNhdmVCdXR0b24iLCJmaW5kIiwiJHVwZGF0ZUJ1dHRvbiIsImRlZmF1bHRzIiwib3B0aW9ucyIsImV4dGVuZCIsIm9uIiwiZXZlbnQiLCJwcmV2ZW50RGVmYXVsdCIsImZvcm1OYW1lIiwiYXR0ciIsIiRmb3JtIiwic3VibWl0IiwiZm9ybVVSTCIsImluaXQiLCJkb25lIl0sIm1hcHBpbmdzIjoiOztBQUFBOzs7Ozs7Ozs7O0FBVUFBLEdBQUdDLFdBQUgsQ0FBZUMsTUFBZixDQUFzQixVQUF0QixFQUFrQyxFQUFsQyxFQUVJLFVBQVVDLElBQVYsRUFBZ0I7O0FBRVo7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7Ozs7OztBQVBZOztBQVlaLFlBQU1DLFFBQVFDLEVBQUUsSUFBRixDQUFkOztBQUVBOzs7OztBQUtBLFlBQU1DLGlCQUFpQkQsRUFBRSxrQkFBRixDQUF2Qjs7QUFFQTs7Ozs7QUFLQSxZQUFNRSxjQUFjRCxlQUFlRSxJQUFmLENBQW9CLHFCQUFwQixDQUFwQjs7QUFFQTs7Ozs7QUFLQSxZQUFNQyxnQkFBZ0JILGVBQWVFLElBQWYsQ0FBb0IsdUJBQXBCLENBQXRCOztBQUVBOzs7OztBQUtBLFlBQU1FLFdBQVcsRUFBakI7O0FBRUE7Ozs7O0FBS0EsWUFBTUMsVUFBVU4sRUFBRU8sTUFBRixDQUFTLElBQVQsRUFBZSxFQUFmLEVBQW1CRixRQUFuQixFQUE2QlAsSUFBN0IsQ0FBaEI7O0FBRUE7Ozs7O0FBS0EsWUFBTUQsU0FBUyxFQUFmOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBSyxvQkFBWU0sRUFBWixDQUFlLE9BQWYsRUFBd0IsVUFBQ0MsS0FBRCxFQUFXO0FBQy9CQSxzQkFBTUMsY0FBTjtBQUNBLG9CQUFNQyxXQUFXWCxFQUFFLEtBQUYsRUFBUVksSUFBUixDQUFhLE1BQWIsQ0FBakI7QUFDQSxvQkFBTUMsUUFBUWIsRUFBRSxVQUFVVyxRQUFaLENBQWQ7O0FBRUFFLHNCQUFNQyxNQUFOO0FBQ0gsU0FORDs7QUFRQTtBQUNBVixzQkFBY0ksRUFBZCxDQUFpQixPQUFqQixFQUEwQixVQUFDQyxLQUFELEVBQVc7QUFDakNBLHNCQUFNQyxjQUFOO0FBQ0Esb0JBQU1DLFdBQVdYLEVBQUUsS0FBRixFQUFRWSxJQUFSLENBQWEsTUFBYixDQUFqQjtBQUNBLG9CQUFNQyxRQUFRYixFQUFFLFVBQVVXLFFBQVosQ0FBZDtBQUNBLG9CQUFNSSxVQUFVRixNQUFNRCxJQUFOLENBQVcsUUFBWCxDQUFoQjs7QUFFQTtBQUNBO0FBQ0FDLHNCQUFNRCxJQUFOLENBQVcsUUFBWCxFQUFxQkcsVUFBVSxXQUEvQjs7QUFFQUYsc0JBQU1DLE1BQU47QUFDSCxTQVhEOztBQWFBO0FBQ0E7QUFDQTs7QUFFQWpCLGVBQU9tQixJQUFQLEdBQWMsVUFBVUMsSUFBVixFQUFnQjtBQUMxQkE7QUFDSCxTQUZEOztBQUlBLGVBQU9wQixNQUFQO0FBQ0gsQ0E5RkwiLCJmaWxlIjoiY29udGVudF9tYW5hZ2VyL3NhdmVfYmFyLmpzIiwic291cmNlc0NvbnRlbnQiOlsiLyogLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS1cclxuIHNhdmVfYmFyLmpzIDIwMTctMTEtMDZcclxuIEdhbWJpbyBHbWJIXHJcbiBodHRwOi8vd3d3LmdhbWJpby5kZVxyXG4gQ29weXJpZ2h0IChjKSAyMDE3IEdhbWJpbyBHbWJIXHJcbiBSZWxlYXNlZCB1bmRlciB0aGUgR05VIEdlbmVyYWwgUHVibGljIExpY2Vuc2UgKFZlcnNpb24gMilcclxuIFtodHRwOi8vd3d3LmdudS5vcmcvbGljZW5zZXMvZ3BsLTIuMC5odG1sXVxyXG4gLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS1cclxuICovXHJcblxyXG5neC5jb250cm9sbGVycy5tb2R1bGUoJ3NhdmVfYmFyJywgW10sXHJcblxyXG4gICAgZnVuY3Rpb24gKGRhdGEpIHtcclxuXHJcbiAgICAgICAgJ3VzZSBzdHJpY3QnO1xyXG5cclxuICAgICAgICAvLyAtLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS1cclxuICAgICAgICAvLyBWQVJJQUJMRVMgREVGSU5JVElPTlxyXG4gICAgICAgIC8vIC0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLVxyXG4gICAgICAgIC8qKlxyXG4gICAgICAgICAqIE1vZHVsZSBTZWxlY3RvclxyXG4gICAgICAgICAqXHJcbiAgICAgICAgICogQHR5cGUge2pRdWVyeX1cclxuICAgICAgICAgKi9cclxuICAgICAgICBjb25zdCAkdGhpcyA9ICQodGhpcyk7XHJcblxyXG4gICAgICAgIC8qKlxyXG4gICAgICAgICAqIEJvdHRvbSBzYXZlIGJhclxyXG4gICAgICAgICAqXHJcbiAgICAgICAgICogQHR5cGUge2pRdWVyeX1cclxuICAgICAgICAgKi9cclxuICAgICAgICBjb25zdCAkYm90dG9tU2F2ZUJhciA9ICQoJy5ib3R0b20tc2F2ZS1iYXInKTtcclxuXHJcbiAgICAgICAgLyoqXHJcbiAgICAgICAgICogU2F2ZSBidXR0b25cclxuICAgICAgICAgKlxyXG4gICAgICAgICAqIEB0eXBlIHtqUXVlcnl9XHJcbiAgICAgICAgICovXHJcbiAgICAgICAgY29uc3QgJHNhdmVCdXR0b24gPSAkYm90dG9tU2F2ZUJhci5maW5kKCdidXR0b25bbmFtZT1cInNhdmVcIl0nKTtcclxuXHJcbiAgICAgICAgLyoqXHJcbiAgICAgICAgICogVXBkYXRlIGJ1dHRvblxyXG4gICAgICAgICAqXHJcbiAgICAgICAgICogQHR5cGUge2pRdWVyeX1cclxuICAgICAgICAgKi9cclxuICAgICAgICBjb25zdCAkdXBkYXRlQnV0dG9uID0gJGJvdHRvbVNhdmVCYXIuZmluZCgnYnV0dG9uW25hbWU9XCJ1cGRhdGVcIl0nKTtcclxuXHJcbiAgICAgICAgLyoqXHJcbiAgICAgICAgICogRGVmYXVsdCBPcHRpb25zXHJcbiAgICAgICAgICpcclxuICAgICAgICAgKiBAdHlwZSB7b2JqZWN0fVxyXG4gICAgICAgICAqL1xyXG4gICAgICAgIGNvbnN0IGRlZmF1bHRzID0ge307XHJcblxyXG4gICAgICAgIC8qKlxyXG4gICAgICAgICAqIEZpbmFsIE9wdGlvbnNcclxuICAgICAgICAgKlxyXG4gICAgICAgICAqIEB0eXBlIHtvYmplY3R9XHJcbiAgICAgICAgICovXHJcbiAgICAgICAgY29uc3Qgb3B0aW9ucyA9ICQuZXh0ZW5kKHRydWUsIHt9LCBkZWZhdWx0cywgZGF0YSk7XHJcblxyXG4gICAgICAgIC8qKlxyXG4gICAgICAgICAqIE1vZHVsZSBPYmplY3RcclxuICAgICAgICAgKlxyXG4gICAgICAgICAqIEB0eXBlIHtvYmplY3R9XHJcbiAgICAgICAgICovXHJcbiAgICAgICAgY29uc3QgbW9kdWxlID0ge307XHJcblxyXG4gICAgICAgIC8vIC0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLVxyXG4gICAgICAgIC8vIEVWRU5UIEhBTkRMRVJTXHJcbiAgICAgICAgLy8gLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tXHJcblxyXG4gICAgICAgIC8vIEhhbmRsZSBzYXZlIGJ1dHRvbiBjbGlja1xyXG4gICAgICAgICRzYXZlQnV0dG9uLm9uKCdjbGljaycsIChldmVudCkgPT4ge1xyXG4gICAgICAgICAgICBldmVudC5wcmV2ZW50RGVmYXVsdCgpO1xyXG4gICAgICAgICAgICBjb25zdCBmb3JtTmFtZSA9ICQodGhpcykuYXR0cignZm9ybScpO1xyXG4gICAgICAgICAgICBjb25zdCAkZm9ybSA9ICQoJ2Zvcm0jJyArIGZvcm1OYW1lKTtcclxuXHJcbiAgICAgICAgICAgICRmb3JtLnN1Ym1pdCgpO1xyXG4gICAgICAgIH0pO1xyXG5cclxuICAgICAgICAvLyBIYW5kbGUgdXBkYXRlIGJ1dHRvbiBjbGlja1xyXG4gICAgICAgICR1cGRhdGVCdXR0b24ub24oJ2NsaWNrJywgKGV2ZW50KSA9PiB7XHJcbiAgICAgICAgICAgIGV2ZW50LnByZXZlbnREZWZhdWx0KCk7XHJcbiAgICAgICAgICAgIGNvbnN0IGZvcm1OYW1lID0gJCh0aGlzKS5hdHRyKCdmb3JtJyk7XHJcbiAgICAgICAgICAgIGNvbnN0ICRmb3JtID0gJCgnZm9ybSMnICsgZm9ybU5hbWUpO1xyXG4gICAgICAgICAgICBjb25zdCBmb3JtVVJMID0gJGZvcm0uYXR0cignYWN0aW9uJyk7XHJcblxyXG4gICAgICAgICAgICAvLyBBZGQgYW5vdGhlciBwYXJhbWV0ZXIsIHNvIHRoYXQgd2Ugc3RheSBvbiB0aGUgc2FtZSBwYWdlIGFmdGVyXHJcbiAgICAgICAgICAgIC8vIHRoZSBmb3JtIHdhcyBzdWJtaXR0ZWRcclxuICAgICAgICAgICAgJGZvcm0uYXR0cignYWN0aW9uJywgZm9ybVVSTCArICcmdXBkYXRlPTEnKTtcclxuXHJcbiAgICAgICAgICAgICRmb3JtLnN1Ym1pdCgpO1xyXG4gICAgICAgIH0pO1xyXG5cclxuICAgICAgICAvLyAtLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS1cclxuICAgICAgICAvLyBJTklUSUFMSVpBVElPTlxyXG4gICAgICAgIC8vIC0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLVxyXG5cclxuICAgICAgICBtb2R1bGUuaW5pdCA9IGZ1bmN0aW9uIChkb25lKSB7XHJcbiAgICAgICAgICAgIGRvbmUoKTtcclxuICAgICAgICB9O1xyXG5cclxuICAgICAgICByZXR1cm4gbW9kdWxlO1xyXG4gICAgfSk7XHJcbiJdfQ==
